/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.mixin;

import java.util.function.Supplier;
import net.adventurez.entity.SummonerEntity;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerWorldMixin
extends Level {
    public ServerWorldMixin(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Inject(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LightningEntity;setCosmetic(Z)V", shift=At.Shift.AFTER)})
    public void tickChunk(LevelChunk chunk, int randomTickSpeed, CallbackInfo info) {
        int spawnChanceInt;
        int summonerSpawnChance = ConfigInit.CONFIG.summoner_thunder_spawn_chance;
        if (summonerSpawnChance != 0 && (spawnChanceInt = this.m_213780_().m_188503_(summonerSpawnChance) + 1) == 1) {
            ChunkPos chunkPos = chunk.m_7697_();
            int i = chunkPos.m_45604_();
            int j = chunkPos.m_45605_();
            BlockPos blockPos = this.m_5452_(Heightmap.Types.MOTION_BLOCKING, this.m_46496_(i, 0, j, 15));
            if (NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)chunk.m_62953_(), (BlockPos)blockPos, EntityInit.SUMMONER)) {
                SummonerEntity summonerEntity = (SummonerEntity)EntityInit.SUMMONER.m_20615_((Level)this);
                summonerEntity.m_20248_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                summonerEntity.m_6518_((ServerLevelAccessor)((ServerLevel)this), this.m_6436_(blockPos), MobSpawnType.EVENT, null, null);
                this.m_7967_((Entity)summonerEntity);
                summonerEntity.m_21373_();
            }
        }
    }
}

